#include <struct.h>
#include <3dengine.h>
#include "paged3d.h"
#include "..\resource.h"


BEGIN_MESSAGE_MAP(CSettingsDialog, CPropertyPage)
  ON_WM_HSCROLL()

  ON_COMMAND(IDOK, OnOK)
  ON_COMMAND(IDC_ACTIVECHECK, UpdateLightProperties)
  ON_COMMAND(IDC_DEFMATCOLOR, OnDefMatColor)
  ON_COMMAND(IDC_FOGCOLOR, OnFogColor)

  ON_CBN_SELCHANGE(IDC_LIGHTCOMBO, SetCurLight)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////////
//               Initialisation
//////////////////////////////////////////////////////////////////////
BOOL CSettingsDialog::OnInitDialog()
{
  pD3D = CurrentState.CurrentParams.pD3D;

  Light[0] = &pD3D->LAmbient;
  Light[1] = &pD3D->LStandart;
  Light[2] = &pD3D->LBack;
  Light[3] = &pD3D->LSpots[0];
  Light[4] = &pD3D->LSpots[1];
  Light[5] = &pD3D->LSpots[2];
  Light[6] = &pD3D->LSpots[3];
    
  ImUpdating = TRUE;
  CComboBox* combo = (CComboBox*)GetDlgItem(IDC_LIGHTCOMBO);

  CRect rect;
  GetDlgItem(IDC_RGBOUT)->GetClientRect(&rect);
  LightColorBar.Create(NULL,
    WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
    rect, GetDlgItem(IDC_RGBOUT));
  LightColorBar.SetProperties(rect, 255,255,255);

  DefMatColorBar.Create(NULL,
    WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
    rect, GetDlgItem(IDC_DEFMATRECT));
  DefMatColorBar.SetProperties(rect, 255,255,255);
  FogColorBar.Create(NULL,
    WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
    rect, GetDlgItem(IDC_FOGRECT));
  FogColorBar.SetProperties(rect, 255,255,255);

  combo->AddString("Ambient");
  combo->AddString("Standard");
  combo->AddString("Back-light");
  combo->AddString("Left spot");
  combo->AddString("Right spot");
  combo->AddString("Upper spot");
  combo->AddString("Lower spot");

  pred  = (CSliderCtrl*)GetDlgItem(IDC_RGB_R);
  pgreen  = (CSliderCtrl*)GetDlgItem(IDC_RGB_G);
  pblue  = (CSliderCtrl*)GetDlgItem(IDC_RGB_B);
  pshade  = (CSliderCtrl*)GetDlgItem(IDC_SHADING);
  pdepth  = (CSliderCtrl*)GetDlgItem(IDC_FOGDEPTH);
  pTrans  = (CSliderCtrl*)GetDlgItem(IDC_TRANS_SLIDER);

  OnCheck = (CButton*)GetDlgItem(IDC_ACTIVECHECK);

  pred->SetRangeMax(255, TRUE);
  pgreen->SetRangeMax(255, TRUE);
  pblue->SetRangeMax(255, TRUE);

  pshade->SetRangeMax(255, TRUE);
  pdepth->SetRangeMax(255, FALSE);
  pdepth->SetPos((BYTE)(pD3D->fogdensity*255));
  pTrans->SetRangeMax(255, FALSE);
  pTrans->SetPos((BYTE)(pD3D->SemiTransparencyFactor*255));


  CurrLight = -1;
  ared  = (BYTE)(((*Light[0] & 0xFF0000)>>16) & 0xFF);
  agreen  = (BYTE)(((*Light[0] & 0xFF00)>>8) & 0xFF);
  ablue  = (BYTE)((*Light[0] & 0xFF) & 0xFF);

  if (pD3D->Materials.MaterialsAmount <= 0)
  {
    GetDlgItem(IDC_DEFMATRECT)->EnableWindow(FALSE);
    GetDlgItem(IDC_DEFMATCOLOR)->EnableWindow(FALSE);
    DefMatColorBar.Deactivate();
  }
  else
  {
    rDM = (BYTE)(pD3D->Materials.Materials[0].MatRec.ambient.r * 255);
    gDM = (BYTE)(pD3D->Materials.Materials[0].MatRec.ambient.g * 255);
    bDM = (BYTE)(pD3D->Materials.Materials[0].MatRec.ambient.b * 255);
    DefMatColorBar.SetColor(rDM, gDM, bDM);
  }

  rFog = (BYTE)((pD3D->Fog & 0xFF0000)>>16);
  gFog = (BYTE)((pD3D->Fog & 0xFF00)>>8);
  bFog = (BYTE)(pD3D->Fog & 0xFF);
  FogColorBar.SetColor(rFog, gFog, bFog );

  UpdateShading(ared, agreen, ablue);


  CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL, "ZModeler\\Settings\\D3D Page", this, NULL);

  combo->SetCurSel(0);
  SetCurLight();
  return TRUE;
}


afx_msg void CSettingsDialog::UpdateLightProperties()
{
  red    = pred->GetPos();
  green  = pgreen->GetPos();
  blue  = pblue->GetPos();

  if (CurrLight >=0)
  {
    *Light[CurrLight] = (((long)red)<<16) + (((long)green)<<8) + (long)blue;
  
    if (OnCheck->GetCheck() == 1)
      *Light[CurrLight] |= BitEnabled;
  }
  ared  = (BYTE)(((*Light[0] & 0xFF0000)>>16) & 0xFF);
  agreen  = (BYTE)(((*Light[0] & 0xFF00)>>8) & 0xFF);
  ablue  = (BYTE)((*Light[0] & 0xFF) & 0xFF);
  UpdateShading(ared, agreen, ablue);

  LightColorBar.SetColor(red, green,blue);
  ImUpdating = FALSE;
  UpdateView();
  ImUpdating = TRUE;
}


void CSettingsDialog::UpdateShading(BYTE r,BYTE g,BYTE b)
{
  if (CurrLight == 0)
  {
    BYTE middle = 255 - ((r + g + b) / 3);
    pshade->SetPos(middle);
  }
}


void CSettingsDialog::UpdateAmbient(BYTE shade)
{
  shade = 255 - shade;
  ared = shade;
  agreen = shade;
  ablue = shade;
  *Light[0] = BitEnabled | (ablue + ((DWORD)agreen << 8) + ((DWORD)ared << 16));

  if (CurrLight == 0)
  {//update scrollbars
    OnCheck->SetCheck(1);
    pred->SetPos(ared);
    pgreen->SetPos(agreen);
    pblue->SetPos(ablue);
    ImUpdating = FALSE;
    UpdateView();
    ImUpdating = TRUE;
  }//update scrollbars
}


afx_msg void CSettingsDialog::OnHScroll( UINT nSBCode, UINT nPos, CScrollBar* pScrollBar )
{
  if ((void*)pScrollBar == (void*)pshade)
    UpdateAmbient(pshade->GetPos());
  else
  if ((void*)pScrollBar == (void*)pdepth)
    pD3D->fogdensity = (float)pdepth->GetPos()/255.0f;
  else
  if ((void*)pScrollBar == (void*)pTrans)
    pD3D->SemiTransparencyFactor = (float)pTrans->GetPos()/255.0f;

  UpdateLightProperties();
}


afx_msg void CSettingsDialog::SetCurLight()
{
  CurrLight = ((CComboBox*)GetDlgItem(IDC_LIGHTCOMBO))->GetCurSel();
  if (CurrLight==CB_ERR)
  {// no items selected in DropDownList
    CurrLight=0;
    ((CComboBox*)GetDlgItem(IDC_LIGHTCOMBO))->SetCurSel(CurrLight);
  }// no items selected in DropDownList
  
  pred->SetPos(BYTE((*Light[CurrLight] & 0xFF0000) >> 16));
  pgreen->SetPos(BYTE((*Light[CurrLight] & 0xFF00) >> 8));
  pblue->SetPos(BYTE(*Light[CurrLight] & 0xFF));
  
  if ((*Light[CurrLight] & BitEnabled) == BitEnabled)
    OnCheck->SetCheck(1);
  else
    OnCheck->SetCheck(0);

  UpdateLightProperties();
}

afx_msg void CSettingsDialog::OnDefMatColor()
{
  CColorDialog cdiag(RGB(rDM, gDM, bDM), CC_RGBINIT | CC_FULLOPEN, this);
  if (cdiag.DoModal() == IDOK)
  {
    bDM = (BYTE)((cdiag.GetColor()&0xFF0000)>>16);
    gDM = (BYTE)((cdiag.GetColor()&0xFF00)>>8);
    rDM = (BYTE)((cdiag.GetColor()&0xFF));
  }
  DefMatColorBar.SetColor(rDM, gDM, bDM);
}

afx_msg void CSettingsDialog::OnFogColor()
{
  CColorDialog cdiag(RGB(rFog, gFog, bFog), CC_RGBINIT | CC_FULLOPEN, this);
  if (cdiag.DoModal() == IDOK)
  {
    bFog = (BYTE)((cdiag.GetColor()&0xFF0000)>>16);
    gFog = (BYTE)((cdiag.GetColor()&0xFF00)>>8);
    rFog = (BYTE)((cdiag.GetColor()&0xFF));
    pD3D->Fog = (pD3D->Fog & 0xFF000000) | (bFog | (gFog<<8) | (rFog<<16));
    ImUpdating = FALSE;
    UpdateView();
    ImUpdating = TRUE;
  }
  FogColorBar.SetColor(rFog, gFog, bFog);
}

//////////////////////////////////////////////////////////////////////
//               Finalisation
//////////////////////////////////////////////////////////////////////
BOOL CSettingsDialog::OnApply()
{
  if (pD3D->Materials.MaterialsAmount > 0)
  {
    pD3D->Materials.Materials[0].MatRec.ambient.r = (float)rDM/255.0f;
    pD3D->Materials.Materials[0].MatRec.ambient.g = (float)gDM/255.0f;
    pD3D->Materials.Materials[0].MatRec.ambient.b = (float)bDM/255.0f;
    pD3D->Materials.Materials[0].MatRec.diffuse.r = (float)rDM/255.0f;
    pD3D->Materials.Materials[0].MatRec.diffuse.g = (float)gDM/255.0f;
    pD3D->Materials.Materials[0].MatRec.diffuse.b = (float)bDM/255.0f;
    pD3D->Materials.Materials[0].MatRec.emissive.r = (float)rDM/1023.0f;
    pD3D->Materials.Materials[0].MatRec.emissive.g = (float)gDM/1023.0f;
    pD3D->Materials.Materials[0].MatRec.emissive.b = (float)bDM/1023.0f;
    pD3D->Materials.Materials[0].MatRec.specular.r = 1.0f;
    pD3D->Materials.Materials[0].MatRec.specular.g = 1.0f;
    pD3D->Materials.Materials[0].MatRec.specular.b = 1.0f;
  }

  ImUpdating = FALSE;
  UpdateView();

  return TRUE;
}


void CSettingsDialog::UpdateView()
{
  if (ImUpdating)
    return;

  SetModified(TRUE);

  z3dViewDescriptor desc;
  DWORD amb = pD3D->LAmbient;
  DWORD str = pD3D->LStandart;
  for (long view = 1; view < 5; view++)
  {
    CurrentState.CurrentParams.sysp(Z3D_REQUEST_GETVIEWDESCRIPTOR, NULL, NULL, &desc, &view);
    desc.LAmbient = amb;
    desc.LStandart = str;
    CurrentState.CurrentParams.sysp(Z3D_REQUEST_SETVIEWDESCRIPTOR, NULL, NULL, &desc, &view);
  }
  CurrentState.CurrentParams.sysp(Z3D_REQUEST_REDRAW3DVIEWS, NULL, NULL, NULL, NULL);
}

